
/* MAGXSND.CPX configuration MagiCMac Sound Driver */
/* PURE C */

#include <cpx.h>
#include <tos.h>
#include <stdio.h>
#include <string.h>

#define soundcmd(a,b) (long)xbios(130,a,b)
#define LTATTEN 0
#define RTATTEN 1
#define LTGAIN 2
#define RTGAIN 3
#define ADDERIN 4
#define ADCINPUT 5
#define SETPRESCALE 6

#define MAX_TAB 8

#define ID_CPX (long)'MGSN'

typedef struct
{
	short version;
	short nb_sources;
	short insource;
	char *tab_sourcename;
	short slot;
} MAGXSND;

typedef struct
{
	long ident;
	union
	{
		long l;
		int i[2];
		char c[4];
	} v;
} COOKIE;

/* prototypes */

int CDECL cpx_call(GRECT *work);
CPXNODE *get_header(long id);

/* variables globales en 1re position du segment DATA */

int slot_hades=0;

/* variables globales */

XCPB	*Xcpb;
CPXNODE *head;
CPXINFO	cpxinfo={cpx_call,0,0,0,0,0,0,0,0,0};
int errno;

/* ressource */

#define DIAL 0
#define DIALTINPUT 3
#define DIALINPUT 4
#define DIALTROPOCOP 5
#define DIALROPOCOP 6
#define DIALOK 7

char *rs_strings[] = {
	"Configure MagiCMac Sound Driver","","",
	"MEQUIGNON Didier V0.96 2002 April","","",
	"Input Source :",
	"No Input Device","","",
	"Hades Audio Output :",
	"MV16-Slot 1 / PSOUND","","",
	"OK" };

long rs_frstr[] = {0};
BITBLK rs_bitblk[] = {0};
long rs_frimg[] = {0};
ICONBLK rs_iconblk[] = {0};

TEDINFO rs_tedinfo[] = {
	(char *)0L,(char *)1L,(char *)2L,IBM,0,2,0X1180,0,2,32,1,
	(char *)3L,(char *)4L,(char *)5L,SMALL,0,2,0x1180,0,0,32,1,
	(char *)7L,(char *)8L,(char *)9L,IBM,0,2,0x1180,0,-1,16,1,
	(char *)11L,(char *)12L,(char *)13L,IBM,0,2,0x1180,0,-1,16,1 };

OBJECT rs_object[] = {
	-1,1,7,G_BOX,FL3DBAK,NORMAL,0x1100L,0,0,32,11,
	2,-1,-1,G_BOXTEXT,FL3DBAK,SELECTED,0L,0,0,32,2,
	3,-1,-1,G_TEXT,FL3DBAK,NORMAL,1L,1,2,30,1,
	4,-1,-1,G_STRING,NONE,NORMAL,6L,9,4,14,1,
	5,-1,-1,G_BOXTEXT,TOUCHEXIT,SHADOWED,2L,8,6,16,1,
	6,-1,-1,G_STRING,NONE,NORMAL,10L,6,4,20,1,
	7,-1,-1,G_BOXTEXT,TOUCHEXIT,SHADOWED,3L,6,6,20,1,	
	0,-1,-1,G_BUTTON,SELECTABLE|DEFAULT|EXIT|LASTOB|FL3DIND|FL3DBAK,NORMAL,14L,12,9,8,1 };

long rs_trindex[] = {0};
struct foobar {
	int dummy;
	int *image;
	} rs_imdope[] = {0};

#define NUM_STRINGS 15	/* nbre de chaines */
#define NUM_FRSTR 0		/* chaines form_alert */
#define NUM_IMAGES 0	/* nbre de BITBLK */
#define NUM_BB 0	
#define NUM_FRIMG 0
#define NUM_IB 0		/* nbre d'ICONBLK */
#define NUM_TI 3		/* nbre de TEDINFO */
#define NUM_OBS 8		/* nbre d'objets */
#define NUM_TREE 1		/* nbre d'arbres */ 

CPXINFO* CDECL cpx_init(XCPB *xcpb)

{
	MAGXSND *infos_cookie;
	long valeur;
	int slot;
	Xcpb=xcpb;
	head=get_header(ID_CPX);
	if(head && !(*Xcpb->get_cookie)('MgMc',&valeur)
	 && (*Xcpb->get_cookie)('MgSn',&valeur) && (infos_cookie=(MAGXSND *)valeur)!=0)
	{
		slot=*((int *)head->cpxhead.buffer);
		if(slot==0 && slot!=slot_hades)	/* buffer du header est toujours  0 avec ZCONTROL */
			slot=slot_hades;
		if(slot<0 || slot>3)
			slot=0;
		infos_cookie->slot=slot;		/* passe la valeur au driver */
	}	
	return(&cpxinfo);
}

int CDECL cpx_call(GRECT *work)

{
	char *spec_choix_slot[]={"      YAMAHA        ","MV16-Slot 1 / PSOUND","MV16-Slot 2 / PSOUND","MV16-Slot 3 / PSOUND"};
	char *choix_slot[]={"        YAMAHA         ","  MV16-Slot 1 / PSOUND ","  MV16-Slot 2 / PSOUND ","  MV16-Slot 3 / PSOUND "};
	char *spec_choix_input[MAX_TAB];
	char *choix_input[MAX_TAB];
	char textes_popup[MAX_TAB][256+2];
	GRECT menu;
	TEDINFO *t_edinfo;
	MAGXSND *infos_cookie;
	int mesag[8];
	char *p,*p2;
	long valeur;
	int i,fin,redraw,ret,nb_input,slot;
	if(!(*Xcpb->get_cookie)('MgSn',&valeur) || (infos_cookie=(MAGXSND *)valeur)==0)
	{
		form_alert(1,"[1][ZMAGXSND.PRG not installed|in the AUTO folder][Cancel]");
		return(0);
	}
	nb_input=infos_cookie->nb_sources;
	if(nb_input>MAX_TAB)
		nb_input=MAX_TAB;
	if(infos_cookie->insource>nb_input)
		infos_cookie->insource=nb_input;
	if(infos_cookie->insource<1)
		infos_cookie->insource=1;
	p=infos_cookie->tab_sourcename;
	for(i=0;i<MAX_TAB;i++)
	{
		if(*p==0)
			break;
		p2=&textes_popup[i][0];
		spec_choix_input[i]=p;
		choix_input[i]=p2;
		p2[0]=' ';
		p2[1]=' ';
		strcpy(&p2[2],p);
		while(*p++);
	}
	if(!(Xcpb->SkipRshFix))
		(*Xcpb->rsh_fix)(NUM_OBS,NUM_FRSTR,NUM_FRIMG,NUM_TREE,rs_object,rs_tedinfo,rs_strings,rs_iconblk,rs_bitblk,rs_frstr,rs_frimg,rs_trindex,rs_imdope);
	rs_object[DIAL].ob_x=work->g_x;
	rs_object[DIAL].ob_y=work->g_y;
	rs_object[DIAL].ob_width=work->g_w;
	rs_object[DIAL].ob_height=work->g_h;
	if((*Xcpb->get_cookie)('MgMc',&valeur)
	 || (infos_cookie->version>95 && nb_input))
	{
		rs_object[DIALTINPUT].ob_flags &= ~HIDETREE;
		rs_object[DIALINPUT].ob_flags &= ~HIDETREE;
		rs_object[DIALTROPOCOP].ob_flags |= HIDETREE;
		rs_object[DIALROPOCOP].ob_flags |= HIDETREE;
		head=0L;
	}
	else
	{
		rs_object[DIALTINPUT].ob_flags |= HIDETREE;
		rs_object[DIALINPUT].ob_flags |= HIDETREE;
		rs_object[DIALTROPOCOP].ob_flags &= ~HIDETREE;
		rs_object[DIALROPOCOP].ob_flags &= ~HIDETREE;
		head=get_header(ID_CPX);
	}
	if(nb_input)
	{
		t_edinfo=rs_object[DIALINPUT].ob_spec.tedinfo;
		t_edinfo->te_ptext=spec_choix_input[infos_cookie->insource-1];
	}
	slot=infos_cookie->slot;
	if(head)
	{
		slot=*((int *)head->cpxhead.buffer);
		if(slot==0 && slot!=slot_hades)	/* buffer du header est toujours  0 avec ZCONTROL */
			slot=slot_hades;
	}
	if(slot<0 || slot>3)
		slot=0;
	t_edinfo=rs_object[DIALROPOCOP].ob_spec.tedinfo;
	t_edinfo->te_ptext=spec_choix_slot[slot];
	infos_cookie->slot=slot;
	fin=0,redraw=1;
	do
	{
		if(redraw)
		{
			objc_draw(rs_object,DIAL,2,PTRS(work));
			redraw=0;
		}
		switch((*Xcpb->Xform_do)(rs_object,0,mesag))
		{
		case DIALINPUT:
			if(nb_input)
			{
				objc_offset(rs_object,DIALINPUT,&menu.g_x,&menu.g_y);
				menu.g_w=rs_object[DIALINPUT].ob_width;
				menu.g_h=rs_object[DIALINPUT].ob_height;
				ret=(*Xcpb->Popup)(choix_input,nb_input,infos_cookie->insource-1,IBM,&menu,work);
				if((ret>=0) && (ret!=infos_cookie->insource-1))
				{
					t_edinfo=rs_object[DIALINPUT].ob_spec.tedinfo;
					t_edinfo->te_ptext=spec_choix_input[ret];
					objc_draw(rs_object,DIALINPUT,2,PTRS(work));
					infos_cookie->insource=ret+1;
					if(ret)
						soundcmd(ADCINPUT,0);			/* ADC sur entre micro */
					else
						soundcmd(ADCINPUT,3);			/* ADC sur PSG */
				}
			}
			break;
		case DIALROPOCOP:
			objc_offset(rs_object,DIALROPOCOP,&menu.g_x,&menu.g_y);
			menu.g_w=rs_object[DIALROPOCOP].ob_width;
			menu.g_h=rs_object[DIALROPOCOP].ob_height;
			ret=(*Xcpb->Popup)(choix_slot,4,slot,IBM,&menu,work);
			if((ret>=0) && (ret!=slot))
			{
				t_edinfo=rs_object[DIALROPOCOP].ob_spec.tedinfo;
				t_edinfo->te_ptext=spec_choix_slot[ret];
				objc_draw(rs_object,DIALROPOCOP,2,PTRS(work));
				infos_cookie->slot=slot=ret;
			}
			break;
		case DIALOK:
		    if(head)
		    {
		    	slot_hades=*((int *)head->cpxhead.buffer)=slot;
				if(((*Xcpb->Save_Header)(head))==0)
					(*Xcpb->XGen_Alert)(FILE_ERR);
				if(((*Xcpb->CPX_Save)((void *)&slot_hades,sizeof(int)))==0)
					(*Xcpb->XGen_Alert)(FILE_ERR);
		    }
			rs_object[DIALOK].ob_state &= ~SELECTED;
			fin=1;
			break;
		case -1:
			switch(mesag[0])
			{
			case CT_KEY:
				break;
			case WM_REDRAW:
				break;
			case WM_CLOSED:
			case AC_CLOSE:
				fin=1;
			}
		}
	}
	while(!fin);
	return(0);
}

CPXNODE *get_header(long id)

{
	register CPXNODE *p;
	p=(CPXNODE *)(*Xcpb->Get_Head_Node)();	/* pointeur header 1er CPX */
	do
	{
		if(p->cpxhead.cpx_id==id)
			return(p);
	}
	while(p->vacant && (p=p->next)!=0);		/* plus de headers */
	return(0L);
}
