#!/bin/sh

#### Cacko HDD fix install.sh ####

WORKDIR=$(echo $PWD)

## Mount the partitions in flash
echo "mounting flash partitions ..."

mkdir /mnt/mtdflash2
mkdir /mnt/mtdflash3
mount /dev/mtdblock2 /mnt/mtdflash2
mount /dev/mtdblock3 /mnt/mtdflash3

## Remove "NotAvailable" in hddX in flash
echo "clearing up the hdd directories in flash ..."

rm -f /mnt/mtdflash2/hdd1/NotAvailable
rm -f /mnt/mtdflash2/hdd2/NotAvailable
rm -f /mnt/mtdflash2/hdd3/NotAvailable


## Make backups of the files to be replaced
echo "making backups of the files to be replaced ..."

TIME=`date +%Y%m%d`

FILE1=/mnt/mtdflash3/QtPalmtop/qpe.sh
FILE2=/mnt/mtdflash2/root/etc/rc.d/rc.rofilesys
FILE3=/mnt/mtdflash2/root/etc/rc.d/rc.sysinit

FILEEXT1=${FILE1}.bak
FILEEXT2=${FILE2}.bak
FILEEXT3=${FILE3}.bak

NEWFILE1=${FILEEXT1}.${TIME}
NEWFILE2=${FILEEXT2}.${TIME}
NEWFILE3=${FILEEXT3}.${TIME}

mv $FILE1 $NEWFILE1
mv $FILE2 $NEWFILE2
mv $FILE3 $NEWFILE3

cp $NEWFILE1 $NEWFILE2 $NEWFILE3 ./backups


## Copy modified system files
echo "copying new files ..."

cp qpe.sh /mnt/mtdflash3/QtPalmtop
cp rc.rofilesys /mnt/mtdflash2/root/etc/rc.d
cp rc.sysinit /mnt/mtdflash2/root/etc/rc.d


## Streamline the booting process a bit
echo "streamlining booting ..."

cd /mnt/mtdflash3/etc/rc.d/rc3.d
if [ -f S04sd ]; then     
    mv S04sd _S04sd
fi
if [ -f S00bvdd ]; then 
    mv S00bvdd _S00bvdd
fi

cd ../rc4.d
if [ -f S04sd ]; then 
    mv S04sd _S04sd
fi
if [ -f S00bvdd ]; then
    mv S00bvdd _S00bvdd
fi

cd ../rc5.d
if [ -f S04sd ]; then
    mv S04sd _S04sd
fi
if [ -f S00bvdd ]; then
    mv S00bvdd _S00bvdd
fi

# Finish
cd $WORKDIR
umount /mnt/mtdflash2
umount /mnt/mtdflash3
rmdir /mnt/mtdflash2
rmdir /mnt/mtdflash3

echo "done"
